<#ibiztemplate>
TARGET=PSAPPDEUILOGIC
</#ibiztemplate>
<#--  获取逻辑节点类型  -->
<#macro getLogicNodeByType logicNode>
<#compress>
    <#if logicNode.getLogicNodeType?? && logicNode.getLogicNodeType()??>
        <#assign type = logicNode.getLogicNodeType()>
        <#if type == 'BEGIN'>
BeginNode
        <#elseif type == 'END'>
EndNode
        <#else>
LogicNodeBase
        </#if>
    <#else>
LogicNodeBase
    </#if>
</#compress>
</#macro>

/**
 * ${item.name}
 *
 * @export
 * @class ${srfclassname('${item.getCodeName()}')}UILogicBase
 */
export default class ${srfclassname('${item.getCodeName()}')}UILogicBase {

    /**
     * Creates an instance of  ${item.codeName}Base.
     * 
     * @param {*} [opts={}]
     * @memberof  ${srfclassname('${item.getCodeName()}')}UILogicBase
     */
    constructor(opts: any = {}) { }


    protected logicNodes: any = {
<#if item.getPSDEUILogicNodes?? && item.getPSDEUILogicNodes()??>
    <#list item.getPSDEUILogicNodes() as logicNode>
        <#assign node>
        codeName: '${logicNode.codeName}',
        name: '${logicNode.name}',
        logicNodeType: '${logicNode.getLogicNodeType()}',
        <#if logicNode.getDstPSDEUILogicParam?? && logicNode.getDstPSDEUILogicParam()??>
        dstParam: '${logicNode.getSrcFieldName().codeName}',
        </#if>
        <#if logicNode.getDstIndex?? && logicNode.getDstIndex()??>
        dstIndex: '${logicNode.getDstIndex()?c}',
        </#if>
        <#if logicNode.getSrcPSDEUILogicParam?? && logicNode.getSrcPSDEUILogicParam()??>
        srcParam: '${logicNode.getSrcPSDEUILogicParam().codeName}',
        </#if>
        <#if logicNode.getSrcFieldName?? && logicNode.getSrcFieldName()??>
        srcFieldName: '${logicNode.getSrcFieldName().codeName}',
        </#if>
        <#if logicNode.getSrcIndex?? && logicNode.getSrcIndex()??>
        srcIndex: '${logicNode.getSrcIndex()?c}',
        </#if>
        <#if logicNode.getSrcSize?? && logicNode.getSrcSize()??>
        srcSize: '${logicNode.getSrcSize()?c}',
        </#if>
        <#if logicNode.getPSDEUILogicLinks?? && logicNode.getPSDEUILogicLinks()??>
        logicLinks: [
            <#list logicNode.getPSDEUILogicLinks() as link>
            {
                name: '${link.name}',
                dstLogicNode: '${link.getDstPSDEUILogicNode().codeName}',
                <#if link.getPSDEUILogicLinkGroupCond?? && link.getPSDEUILogicLinkGroupCond()??>
                //  逻辑连接暂未支持
                linkGroupCond: [],
                </#if>
            }
            </#list>
        ]
        </#if>
        </#assign>
        <@compress single_line=true>'${logicNode.codeName}': new <@getLogicNodeByType logicNode />({ ${node} }),</@compress>
    </#list>
</#if>
    }

    /**
     * 执行
     *
     * @param {any[]} args
     * @param {*} [context={}]
     * @param {*} [params={}]
     * @param {*} [$event]
     * @param {*} [xData]
     * @param {*} [actionContext]
     * @param {string} [srfParentDeName]
     * @memberof GridViewLoadUILogicBase
     */
    execute(args: any[], context:any = {} ,params: any = {}, $event?: any, xData?: any, actionContext?: any, srfParentDeName?: string) {
        console.log('执行UILogic ${item.name}');
    }


}